#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

SYSLOGNG_CLIENT_IP=""
SYSLOGNG_CLIENT_PORT=1234
SYSLOGNG_CLIENT_TRANS_MODE=tcp
SYSLOGNG_CLIENT_SSL=0
SYSLOGNG_CLIENT_FORMAT=bsd
SYSLOGNG_CLIENT_FAC_FILTER=""
SYSLOGNG_CLIENT_SEV_FILTER=""

SyslogClientConfigGen(){
    SyslogClientSettingGet

    ClientConfDataClear

    touch ${SYSLOGNG_CONFIG_CLIENT}
    ClientSrcProcess
    ClientFilterProcess
    ClientDestProcess
    ClientLogProcess
}

SyslogClientConfigClr(){
    ClientConfDataClear
}

########################

SyslogClientSettingGet(){
    if [ ! -f "${SYSLOGNG_CLIENT_SETTING}" ]; then
        echo "Syslog client setting file does not exist!"
        exit 1
    fi

    SYSLOGNG_CLIENT_IP=`/bin/get_key_value ${SYSLOGNG_CLIENT_SETTING} server_addr`
    SYSLOGNG_CLIENT_PORT=`/bin/get_key_value ${SYSLOGNG_CLIENT_SETTING} server_port`
    SYSLOGNG_CLIENT_TRANS_MODE=`/bin/get_key_value ${SYSLOGNG_CLIENT_SETTING} server_trans`
    SYSLOGNG_CLIENT_SSL=`/bin/get_key_value ${SYSLOGNG_CLIENT_SETTING} server_ssl`
    SYSLOGNG_CLIENT_FORMAT=`/bin/get_key_value ${SYSLOGNG_CLIENT_SETTING} server_format`
    SYSLOGNG_CLIENT_FAC_FILTER=`/bin/get_key_value ${SYSLOGNG_CLIENT_SETTING} server_facfilter`
    SYSLOGNG_CLIENT_SEV_FILTER=`/bin/get_key_value ${SYSLOGNG_CLIENT_SETTING} server_sevfilter`
    SYSLOGNG_CLIENT_CA_FILE_PATH=`/bin/get_key_value ${SYSLOGNG_CLIENT_SETTING} server_ca_path`
    SYSLOGNG_CLIENT_IPTYPE=`/bin/get_key_value ${SYSLOGNG_CLIENT_SETTING} server_addr_type`
}

ClientConfDataClear(){
    rm -rf ${SYSLOGNG_CONFIG_CLIENT} > /dev/null 2>&1
}

ClientSrcProcess(){
    # Regen common conf for s_syno_syslog
    rm ${SYSLOGNG_CONFIG_COMMON}
    if [ "ietf" == "${SYSLOGNG_CLIENT_FORMAT}" ]; then
        echo 'source s_syno_syslog { unix-stream("/var/run/syslog" flags(syslog-protocol)); };' \
        >> ${SYSLOGNG_CONFIG_COMMON}
    else
        echo 'source s_syno_syslog { unix-stream("/var/run/syslog"); };' \
        >> ${SYSLOGNG_CONFIG_COMMON}
    fi
}

ClientFilterProcess(){
    # Facility filter
    local SYSLOGNG_FAC_FILTER_LIST=`echo ${SYSLOGNG_CLIENT_FAC_FILTER} | sed 's/,/ /g'`
    local SYSLOGNG_FAC_FILTER_STRING=""
    local FAC_STRING=""
    for fac in ${SYSLOGNG_FAC_FILTER_LIST}
    do
        if [ -n "${fac}" ]; then
            if [ -z "${SYSLOGNG_FAC_FILTER_STRING}" ]; then
                SYSLOGNG_FAC_FILTER_STRING="program(${fac} type(\"string\"))"
            else
                SYSLOGNG_FAC_FILTER_STRING="${SYSLOGNG_FAC_FILTER_STRING} or program(${fac} type(\"string\"))"
            fi
        fi
    done

    if [ "" = "${SYSLOGNG_FAC_FILTER_STRING}" ]; then
        SYSLOGNG_FAC_FILTER_STRING="program(no_fac)"
    fi

    cat ${SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/filter_fac.template |
    sed -e "s/__SYSLOG_FAC_FILTER__/${SYSLOGNG_FAC_FILTER_STRING}/" \
    >> ${SYSLOGNG_CONFIG_CLIENT}

    # Severity filter
    local SYSLOGNG_SEV_FILTER_LIST=`echo ${SYSLOGNG_CLIENT_SEV_FILTER} | sed 's/,/ /g'`
    local SYSLOGNG_SEV_FILTER_STRING=""
    local PRIO_STRING=""
    for prio in ${SYSLOGNG_SEV_FILTER_LIST}
    do
        if [ -n "${prio}" ]; then
            if [ "error" = "${prio}" ]; then
                PRIO_STRING="emerg,alert,crit,err"
            elif [ "warning" = "${prio}" ]; then
                PRIO_STRING="warning"
            elif [ "info" = "${prio}" ]; then
                PRIO_STRING="notice,info"
            fi

            if [ -z ${SYSLOGNG_SEV_FILTER_STRING} ]; then
                SYSLOGNG_SEV_FILTER_STRING="${PRIO_STRING}"
            else
                SYSLOGNG_SEV_FILTER_STRING="${SYSLOGNG_SEV_FILTER_STRING},${PRIO_STRING}"
            fi
        fi
    done

    cat ${SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/filter_sev.template |
    sed -e "s/__SYSLOG_SEV_FILTER__/${SYSLOGNG_SEV_FILTER_STRING}/" \
    >> ${SYSLOGNG_CONFIG_CLIENT}
}

ClientDestProcess(){
    local DSTTYPE="network"
    local TRANSPORT="udp"
    local TLS_RULE=""

    if [ "ietf" == ${SYSLOGNG_CLIENT_FORMAT} ]; then
        DSTTYPE="syslog"
    fi

    if [ "tcp" == ${SYSLOGNG_CLIENT_TRANS_MODE} ]; then
        TRANSPORT="tcp"
        if [ "1" == ${SYSLOGNG_CLIENT_SSL} ]; then
            TRANSPORT="tls"
            TLS_RULE="tls(ca_dir(\"${SYSLOGNG_CLIENT_CA_FILE_PATH}\"))"
        fi
    fi

    if [ -z "${SYSLOGNG_CLIENT_IPTYPE}" ]; then
        SYSLOGNG_CLIENT_IPTYPE="4"
    fi

    cat ${SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/dest.template |
    sed -e "s/__SYNO_DSTTYPE__/${DSTTYPE}/" \
        -e "s/__SYNO_IP__/\"${SYSLOGNG_CLIENT_IP}\"/" \
        -e "s/__SYNO_PORT__/${SYSLOGNG_CLIENT_PORT}/" \
        -e "s/__SYNO_TRANSPORT__/${TRANSPORT}/" \
        -e "s/__SYNO_IPV__/${SYSLOGNG_CLIENT_IPTYPE}/" \
        -e "s=__SYNO_CA_SETTING__=${TLS_RULE}=" \
        >> ${SYSLOGNG_CONFIG_CLIENT}
}

ClientLogProcess(){
    cat ${SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/log_socket_to_net.template >> ${SYSLOGNG_CONFIG_CLIENT}
}
